/**
 * A module to access exposed configuration values. These values may be evaluated.
 * This module is loaded upon plugin-load, it is advised to have this plugin loaded as one of the first ICN plugins.
 * 
 * Usage: require("CentralConfiguration").get("configured.value","default if null/not available");
 * @author nl.ivojonker
 */
define("CentralConfiguration",["ecm/model/Request"],function(Request) {
	var configuration = null;
	
	var fetchConfiguration=function (synchronous){
		Request.invokePluginService("CentralConfigurationPlugin","ConfigurationService",{
			requestParams: {instruction:"config"},
			synchronous : synchronous,
			requestCompleteCallback: function(response){
				configuration = {};
				for (var i=0;i<response.length;i++){
					try{
						configuration[response[i].key]=response[i].evaluate? eval(response[i].value) : response[i].value;
					}catch(any){
						alert("CentralConfiguration error while evaluating the following content for:"+response[i].key+"\n\n"+response[i].value);
					}
				}
			},
			requestFailedCallback: function(){
				console.error("Error while trying to receive CentralConfiguration.");
				console.log(arguments);
			}
			});
	};
	
	//Todo, check if logged in, then fetchConfiguration(false);
	
	return {
		/*
		 * Returns a value (if exposed in the plugin configuration) 
		 */
		get : function(key,valueIfNullOrNotPresent){
			if (configuration == null)
				fetchConfiguration(true);
			
			return configuration[key] ? configuration[key] : (valueIfNullOrNotPresent ? valueIfNullOrNotPresent : null);			
		}
	};
});
